#include <bits/stdc++.h>
using namespace std;

int n;
vector<int> graph[2][200005];
int camefrom[2][200005];
bool visited[2][200005];

void dfs0(int v, int p, int dest){
    if(visited[0][v])
        return;
    camefrom[0][v] = p;
    visited[0][v] = true;
    if(v == dest)
        return;
    for(auto x : graph[0][v]){
        if(!visited[0][x])
            dfs0(x, v, dest);
    }
}

void dfs1(int v, int p, int dest){
    if(visited[1][v])
        return;
    camefrom[1][v] = p;
    visited[1][v] = true;
    if(v == dest)
        return;
    for(auto x : graph[1][v]){
        if(!visited[1][x])
            dfs1(x, v, dest);
    }
}

void solve1(int Q, int *U1, int *V1, int *U2, int *V2, int *A1, int *B1, int *C1, int *D1, int *R){
    for(int t = 1; t <= Q; ++t){
        for(int i = 1; i <= n; ++i){
            visited[0][i] = false;
            visited[1][i] = false;
            camefrom[0][i] = -1;
            camefrom[1][i] = -1;
        }

        dfs0(A1[t], -1, B1[t]);
        dfs1(C1[t], -1, D1[t]);

        set<int> vk1;
        int cur = B1[t];
        while(cur != -1){
            vk1.insert(cur);
            cur = camefrom[0][cur];
        }

        set<int> vk2;
        cur = D1[t];
        while(cur != -1){
            vk2.insert(cur);
            cur = camefrom[1][cur];
        }

        R[t] = 0;
        for(auto x : vk1){
            if(vk2.find(x) != vk2.end())
                R[t]++;
        }
    }
}

int nval[200005];
int wheren[200005];

void setnvals(){
    int start = -1;
    for(int i = 1; i <= n; ++i){
        if(graph[0][i].size() == 1){
            start = i;
            break;
        }
    }

    nval[start] = 1;
    int crval = 2;
    int nx = graph[0][start][0];
    while(graph[0][nx].size() != 1){
        nval[nx] = crval++;
        for(auto x : graph[0][nx]){
            if(nval[x] == 0){
                nx = x;
                break;
            }
        }
    }
    nval[nx] = crval;
}

int arr2[200005];

void makearr2(){
    int start = -1;
    for(int i = 1; i <= n; ++i){
        if(graph[1][i].size() == 1){
            start = i;
            break;
        }
    }

    bool fakevis[200005] = {};

    int ind = 1;
    arr2[ind++] = nval[start];
    int nx = graph[1][start][0];
    fakevis[start] = true;
    while(graph[1][nx].size() != 1){
        arr2[ind++] = nval[nx];
        fakevis[nx] = true;
        for(auto x : graph[1][nx]){
            if(!fakevis[x]){
                nx = x;
            }
        }
    }
    arr2[ind] = nval[nx];

    for(int i = 1; i <= n; ++i){
        wheren[arr2[i]] = i;
    }
}

struct Query{
    int left, right, ind;
    bool operator<(const Query& other)const{
        return right < other.right; //same as wheren[nval[right]] < wheren[nval[other.right]]
    }
    Query(int x, int y, int z) : left(x), right(y), ind(z) {}
    Query() : left(0), right(0), ind(0){}
};

const int BLOCKSIZE = 448; // sqrt(200005);

pair<Query, Query> queries[200005]; //{C1, D1}, {A1, B1} so it gets sorted by {C1, D1}
vector<pair<Query, Query>> blocks[448];

int cnt[200005];
int st[200005 * 4];

void update(int x, int id, int l, int r){
    if(x > r || x < l)
        return;
    if(l == r){
        st[id] = cnt[l];
        return;
    }
    int mid = (l + r) / 2;
    update(x, id * 2 + 1, l, mid);
    update(x, id * 2 + 2, mid + 1, r);
    st[id] = st[id * 2 + 1] + st[id * 2 + 2];
}

int getSum(int x, int y, int id, int l, int r){
    if(x > r || y < l)
        return 0;
    if(x <= l && r <= y){
        return st[id];
    }
    int mid = (l + r) / 2;
    int v1 = getSum(x, y, id * 2 + 1, l, mid);
    int v2 = getSum(x, y, id * 2 + 2, mid + 1, r);
    return v1 + v2;
}

void solve2(int Q, int *U1, int *V1, int *U2, int *V2, int *A1, int *B1, int *C1, int *D1, int *R){
    setnvals();
    makearr2(); //works

    for(int i = 1; i <= Q; ++i){
        Query q1(A1[i], B1[i], i);
        Query q2(C1[i], D1[i], i);
        queries[i] = {q2, q1};
    }
    sort(queries + 1, queries + Q + 1);

    for(int i = 1; i <= Q; ++i){
        blocks[queries[i].first.left / BLOCKSIZE].push_back(queries[i]);
    }

    for(int i = 0; i <= BLOCKSIZE; ++i){
        int left = 0, right = 0;
        for(int j = 0; j < (int)blocks[i].size(); ++j){
            int cl = wheren[nval[blocks[i][j].first.left]]; //would be same as ind(blocks[i][j].first/left)
            int cr = wheren[nval[blocks[i][j].first.right]]; // -||-
            if(cl > cr)
                swap(cl, cr);
            while(right < cr){
                right++;
                cnt[arr2[right]]++;
                update(arr2[right], 0, 1, n);
            }
            while(left < cl){
                cnt[arr2[left]]--;
                update(arr2[left], 0, 1, n);
                left++;
            }
            while(left > cl){
                left--;
                cnt[arr2[left]]++;
                update(arr2[left], 0, 1, n);
            }

            int v1 = nval[blocks[i][j].second.left];
            int v2 = nval[blocks[i][j].second.right];
            int sum = getSum(min(v1, v2), max(v1, v2), 0, 1, n);
            R[blocks[i][j].first.ind] = sum;
        }
        while(left <= right){
            cnt[arr2[left]]--;
            update(arr2[left], 0, 1, n);
            left++;
        }
    }
}

void Resi(int N, int Q, int P, int *U1, int *V1, int *U2, int *V2, int *A1, int *B1, int *C1, int *D1, int *R){
    n = N;
    for(int i = 1; i < n; ++i){
        graph[0][U1[i]].push_back(V1[i]);
        graph[0][V1[i]].push_back(U1[i]);
    }
    for(int i = 1; i < n; ++i){
        graph[1][U2[i]].push_back(V2[i]);
        graph[1][V2[i]].push_back(U2[i]);
    }
    if(n <= 1000){
        solve1(Q, U1, V1, U2, V2, A1, B1, C1, D1, R);
    }else{
        solve2(Q, U1, V1, U2, V2, A1, B1, C1, D1, R);
    }
}


/*
7 4 0
4 7
2 4
7 5
1 5
1 3
3 6
7 3
3 6
6 2
2 1
1 5
5 4
4 1 4 1
2 6 5 2
1 6 3 7
7 5 1 3
---
3
3
1
0

*/